#include "stdafx.h"
#include "win_demo.h"
#include "DialogMaintenance.h"
#include "afxdialogex.h"
#include "sdks.h"


extern int m_handle;
extern int m_chn_option;
IMPLEMENT_DYNAMIC(CDialogMaintenance, CDialogEx)

CDialogMaintenance::CDialogMaintenance(CWnd* pParent /*=NULL*/)
	: CDialogEx(IDD_DIALOG_MAINTENANCE, pParent)
{

}

CDialogMaintenance::~CDialogMaintenance()
{
}

void CDialogMaintenance::DoDataExchange(CDataExchange* pDX)
{
	CDialogEx::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_BUTTON_UPDATE, m_update);
}

BOOL CDialogMaintenance::OnInitMaintenance()
{
	m_update.EnableWindow(FALSE);
	((CButton*)GetDlgItem(IDC_CHECK_RESERVE_IP))->SetCheck(1);
	return TRUE;
}

BEGIN_MESSAGE_MAP(CDialogMaintenance, CDialogEx)
	ON_BN_CLICKED(IDC_BUTTON_RESTART, &CDialogMaintenance::OnBnClickedButtonRestart)
	ON_BN_CLICKED(IDC_BUTTON_CHOOSE_FILE, &CDialogMaintenance::OnBnClickedButtonChooseFile)
	ON_BN_CLICKED(IDC_BUTTON_UPDATE, &CDialogMaintenance::OnBnClickedButtonUpdate)
	ON_BN_CLICKED(IDC_BUTTON_RESET_FACTORY, &CDialogMaintenance::OnBnClickedButtonResetFactory)
END_MESSAGE_MAP()


void CDialogMaintenance::OnBnClickedButtonRestart()
{
	UINT i = 0;
	i = MessageBoxA(_T("Are you sure you want to restart the device?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
	if (IDYES == i)
	{
		sdks_dev_close_ptz(m_handle);
		sdks_dev_reboot(m_handle, m_chn_option);
	}
}

void CDialogMaintenance::OnBnClickedButtonChooseFile()
{
	CFileDialog fileDlg(TRUE, NULL, NULL, OFN_HIDEREADONLY | OFN_OVERWRITEPROMPT, _T("All Files(*.*)|*.*||"));
	if (fileDlg.DoModal() == IDOK)
	{
		m_file_name = fileDlg.GetPathName();
		SetDlgItemText(IDC_EDIT_UPDATE_FILE_NAME, m_file_name);
	}
	if (NULL != m_file_name.GetBuffer(m_file_name.GetLength()))
	{
		m_update.EnableWindow(TRUE);
	}
}

void CDialogMaintenance::OnBnClickedButtonUpdate()
{
	UINT i = 0;
	i = MessageBoxA(_T("Are you sure you want to upgrade the device?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
	if (IDYES == i)
	{
		sdks_update_ipc(m_handle, m_file_name.GetBuffer(m_file_name.GetLength()));
	}
}

void CDialogMaintenance::OnBnClickedButtonResetFactory()
{
	int reserve_type = 0;
	UINT i = 0;
	i = MessageBoxA(_T("Are you sure you want to restore factory Settings?"), _T("Prompt"), MB_YESNO | MB_ICONQUESTION);
	if (IDYES == i)
	{	
		if (((CButton*)GetDlgItem(IDC_CHECK_RESERVE_IP))->GetCheck() == TRUE)
		{
			reserve_type = 1;
		}
		sdks_dev_reset(m_handle, m_chn_option, reserve_type);
	}
}